import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/presentation/components/components.dart';

class CustomersList extends StatelessWidget {
  final String? imageUrl;
  final String? name;
  final String? lastname;
  final String? gmail;
  final String? date;

  const CustomersList({
    super.key,
    this.imageUrl,
    this.name,
    this.gmail,
    this.date,
    this.lastname,
  });

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        14.verticalSpace,
        Row(
          children: [
            Expanded(
              child: Divider(
                color: Style.black.withOpacity(0.2),
              ),
            )
          ],
        ),
        14.verticalSpace,
        Row(
          children: [
            CommonImage(
              url: imageUrl,
              radius: 25,
              height: 50,
              width: 50,
            ),
            14.horizontalSpace,
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  '${name ?? ''} ${lastname ?? ''}',
                  style: Style.interMedium(
                      size: 16,
                      color: Style.black,
                  ),
                ),
                4.verticalSpace,
                Text(
                  gmail ?? '',
                  style: Style.interRegular(
                      size: 12,
                      color: Style.iconColor,
                     ),
                )
              ],
            ),
            const Spacer(),
            Text(
              date ?? '',
              style: Style.interRegular(
                  size: 12,
                  color: Style.iconColor,),
            ),
            8.horizontalSpace,
          ],
        ),
      ],
    );
  }
}
